<?php
/**
 * Uninstall script for Media Bulk Download plugin
 * 
 * This file is executed when the plugin is deleted through the WordPress admin.
 * It cleans up any temporary ZIP files that might have been left behind.
 */

// Prevent direct access
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Clean up any remaining temporary ZIP files
$upload_dir = wp_upload_dir();
$pattern = $upload_dir['basedir'] . '/media-bulk-download-*.zip';
$files = glob($pattern);

if ($files) {
    foreach ($files as $file) {
        if (file_exists($file)) {
            wp_delete_file($file);
        }
    }
}

// Remove any plugin options if they exist
delete_option('mbd_settings');
delete_option('mbd_version');
